


sampledates_vec = {...
	[2016,04,26,14,00,00],[2016,04,26,15,30,00];...
	[2016,04,28,09,45,00],[2016,04,28,14,50,00];...
	[2016,04,28,18,30,00],[2016,04,29,04,30,00];...
	[2016,05,01,11,30,00],[2016,05,01,15,30,00];...
	[2016,05,02,09,00,00],[2016,05,02,17,15,00];...
	[2016,05,02,20,00,00],[2016,05,03,06,00,00];...
	[2016,05,05,08,00,00],[2016,05,05,21,00,00];...
	[2016,05,06,12,00,00],[2016,05,06,16,45,00];...
	[2016,05,07,11,00,00],[2016,05,07,15,40,00];...
	[2016,05,10,12,00,00],[2016,05,10,16,45,00];...
	[2016,05,14,11,00,00],[2016,05,14,15,45,00]};

sampledates = cellfun(@datetime,sampledates_vec);

raintimes = {...
	[2016,04,26,23,17,00], [2016,04,27,03,30,00];...
	[2016,04,29,12,40,00], [2016,04,29,14,31,00];...
	[2016,04,29,18,20,00], [2016,04,29,19,14,00];...
	[2016,05,10,00,47,00], [2016,05,10,01,32,00];...
	[2016,05,13,22,49,00], [2016,05,14,00,31,00];... %high Im(RI)
	[2016,05,16,06,25,00], [2016,05,16,09,03,00];... %high Im(RI)
	[2016,05,16,15,17,00], [2016,05,16,16,52,00];...
	[2016,05,17,04,13,00], [2016,05,17,07,02,00]};   %low Im(RI)


		
% [apstime, dbins, sizedist, binwidth] = hiscale_APSimport();
[smpstime, dbins, sizedist] = hiscale_importSMPS();

time = smpstime;

sampledist = [];
raindist = [];

for s = 1:size(sampledates,1)
	
	if s <= size(raintimes,1)
		[~,rain_s] = min(abs(datenum(raintimes{s,1}) - datenum(time)));
		[~,rain_e] = min(abs(datenum(raintimes{s,2}) - datenum(time)));
		
		currraindist = nanmean(sizedist(:,rain_s:rain_e),2);
		raindist = [raindist ; currraindist'];
	end
	
	[~,sidx] = min(abs(datenum(sampledates(s,1)) - datenum(time)));
	[~,eidx] = min(abs(datenum(sampledates(s,2)) - datenum(time)));
	
	currsampledist = nanmean(sizedist(:,sidx:eidx),2);
	
	sampledist = [sampledist ; currsampledist'];
	
	
end

figure; hold on;

plot(dbins,sampledist(2,:));
plot(dbins,sampledist(7,:));
plot(dbins,sampledist(11,:).*10);
set(gca,'XScale','log');
xlabel('Aerodynamic Size (nm)');
ylabel('dN/dlogDp');
legend({'Apr 28th','May 5th','May 14th (x10)'},'Box','off');